<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : length
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                
#  Last update : 10/10/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!--limited to 200-->
	<xsl:template match="ted:PROCUREMENT_LAW
|ted:TITLE
|ted:MAIN_SITE" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>200)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'200'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--limited to 400-->
	<xsl:template match="ted:ESTIMATED_TIMING
|ted:INFO_ADD_EAUCTION
|ted:INFO_ADD_SUBCONTRACTING
|ted:INFO_ADD_VALUE
|ted:JUSTIFICATION
|ted:LOT_COMBINING_CONTRACT_RIGHT
|ted:OBJECT_CONTRACT//ted:INFO_ADD
|ted:PLACE
|ted:PROCEDURE//ted:INFO_ADD
|ted:RENEWAL_DESCR" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>400)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'400'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--limited to 500-->
	<xsl:template match="ted:MAIN_FEATURES_AWARD" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>500)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'500'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--limited to 1000-->
	<xsl:template match="
ted:ACCELERATED_PROC
|ted:ADDITIONAL_NEED
|ted:CONDITIONS
|ted:DEPOSIT_GUARANTEE_REQUIRED
|ted:LEGAL_FORM
|ted:MAIN_FINANCING_CONDITION
|ted:METHODS
|ted:PERFORMANCE_CONDITIONS
|ted:RULES_CRITERIA
|ted:OBJECT_CONTRACT/ted:SHORT_DESCR
|ted:UNFORESEEN_CIRCUMSTANCE" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>1000)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'1000'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--limited to 1500-->
	<xsl:template match="
ted:CRITERIA_EVALUATION
|ted:DETAILS_PAYMENT
|ted:NUMBER_VALUE_PRIZE
|ted:REFERENCE_TO_LAW" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>1500)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'1500'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--limited to 2500-->
	<xsl:template match="ted:D_JUSTIFICATION" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>2500)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'2500'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--limited to 4000-->
	<xsl:template match="
ted:CRITERIA_CANDIDATE
|ted:CRITERIA_SELECTION
|ted:ECONOMIC_FINANCIAL_INFO
|ted:ECONOMIC_FINANCIAL_MIN_LEVEL
|ted:COMPLEMENTARY_INFO/ted:INFO_ADD
|ted:CHANGES/ted:INFO_ADD
|ted:OPTIONS_DESCR
|ted:REVIEW_PROCEDURE
|ted:OBJECT_DESCR/ted:SHORT_DESCR
|ted:MODIFICATIONS_CONTRACT//ted:SHORT_DESCR
|ted:SUITABILITY
|ted:TECHNICAL_PROFESSIONAL_INFO
|ted:TECHNICAL_PROFESSIONAL_MIN_LEVEL
|ted:TEXT" mode="R999">
		<xsl:choose>
			<xsl:when test="not(string-length()>4000)"/>
			<xsl:otherwise>
				<xsl:call-template name="length">
					<xsl:with-param name="path" select="."/>
					<xsl:with-param name="size" select="'4000'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template name="length">
		<xsl:param name="path"/>
		<xsl:param name="size"/>
		<xsl:choose>
			<xsl:when test="$path/ancestor::ted:OBJECT_DESCR">
				<xsl:variable name="ele" select="concat('string-length(OBJECT_CONTRACT[',$path/ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',$path/ancestor::ted:OBJECT_DESCR/@ITEM,']//',$path/local-name(),') exceeds ',$size)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R999'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$path/ancestor::ted:OBJECT_CONTRACT">
				<xsl:variable name="ele" select="concat('string-length(OBJECT_CONTRACT[',$path/ancestor::ted:OBJECT_CONTRACT/@ITEM,']//',$path/local-name(),') exceeds ',$size)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R999'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$path/ancestor::ted:AWARD_CONTRACT">
				<xsl:variable name="ele" select="concat('string-length(AWARD_CONTRACT[',$path/ancestor::ted:AWARD_CONTRACT/@ITEM,']//',$path/local-name(),') exceeds ',$size)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R999'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('string-length(',$path/local-name(),') exceeds ',$size)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R999'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
